package org.msh.tb.bd.dashboard.summaryrep.data;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by mauri on 06/07/2017.
 */
public class GeoDistributionData {

    /**
     * The admin unit name or country name
     */
    private String locationDesc;

    /**
     * The period message key description
     */
    private String periodDesc;

    /**
     * A parameter to the period message key
     */
    private String periodDescParam;

    /**
     * The indicator code, eg 'indicator01'
     */
    private String code;

    /**
     * Bigger value in the items list
     * Used to help in markers size calculation
     */
    private Float maxValue;

    /**
     * Maximum circle size
     * This will help calculating the bigger marker and proportionally the others
     */
    private Integer maximumCircleSize;

    /**
     * The item list that will be represented on the map
     */
    private List<GeoDistributionItemData> items;

    /**
     *
     * @param description
     * @param value
     * @param latitude
     * @param longitude
     * @return true if item could be created and inserted;
     */
    public void addItem(String description, Float value, Double latitude, Double longitude) {
        if (items == null) {
            items = new ArrayList<GeoDistributionItemData>();
            maxValue = value;
        }

        if (maxValue < value) {
            maxValue = value;
        }

        GeoDistributionItemData item = new GeoDistributionItemData();
        item.setDescription(description);
        item.setValue(value);
        if (latitude != null || longitude != null) {
            item.setLatlng(new Double[]{latitude, longitude});
        } else {
            item.setLatlng(null);
        }

        items.add(item);
    }

    public String getLocationDesc() {
        return locationDesc;
    }

    public void setLocationDesc(String locationDesc) {
        this.locationDesc = locationDesc;
    }

    public String getPeriodDesc() {
        return periodDesc;
    }

    public void setPeriodDesc(String periodDesc) {
        this.periodDesc = periodDesc;
    }

    public String getPeriodDescParam() {
        return periodDescParam;
    }

    public void setPeriodDescParam(String periodDescParam) {
        this.periodDescParam = periodDescParam;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public List<GeoDistributionItemData> getItems() {
        return items;
    }

    public void setItems(List<GeoDistributionItemData> items) {
        this.items = items;
    }

    public Float getMaxValue() {
        return maxValue;
    }

    public void setMaxValue(Float maxValue) {
        this.maxValue = maxValue;
    }

    public Integer getMaximumCircleSize() {
        return maximumCircleSize;
    }

    public void setMaximumCircleSize(Integer maximumCircleSize) {
        this.maximumCircleSize = maximumCircleSize;
    }
}
